/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import craterstudio.misc.gui.CssTextPane;
import craterstudio.misc.gui.UserIO;

public class CssTextPaneTest {
    public static void main(String[] args) {
        UserIO.setSystemLookAndFeel();
        CssTextPane pane = new CssTextPane();
        pane.defineStyle("*        { color: #f00; font-style: italic;font-size:12; font-family: courier; } ");
        pane.defineStyle("digit    { color: #00f; font-style: normal; } ");
        pane.defineStyle("address  { color: #c0c; font-style: normal; } ");
        pane.defineStyle("const    { color: #080; font-style: normal; } ");
        pane.defineStyle("labeluse { color: #c40; font-style: normal; } ");
        pane.defineStyle("labeldef { color: #808; font-style: normal; } ");
        pane.defineStyle("comment  { color: #088; font-style: italic;text-decoration: none } ");
        String pre = "^|\\s|\\G";
        String post = "\\s|//|$";
        pane.addSyntaxElement("digit", "(" + pre + ")(\\d+)(" + post + ")", 2);
        pane.addSyntaxElement("address", "(" + pre + ")(@\\d+)(\\s|//|$)", 2);
        pane.addSyntaxElement("const", "(" + pre + ")(HLT|ADD|SUB|STA|LDA|BRA|BRZ|BRP|INP|OUT)(" + post + ")", 2);
        pane.addSyntaxElement("labeluse", "(" + pre + ")(:[a-zA-Z0-9]+)(" + post + ")", 2);
        pane.addSyntaxElement("labeldef", "(" + pre + ")([a-zA-Z0-9]+:)(" + post + ")", 2);
        pane.addSyntaxElement("comment", "(//.*$)", 1);
        pane.activateUndoRedo();
        pane.activateAutoRestyle();
        UserIO.createDefaultFrame(pane.wrapInScrollPane(640, 480));
    }
}

