/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import craterstudio.func.BooleanProducer;
import craterstudio.misc.gui.BooleanCallable;
import craterstudio.misc.gui.BoundTask;
import craterstudio.misc.gui.SwingCallback;
import craterstudio.time.Clock;
import craterstudio.util.Asserts;
import craterstudio.util.HighLevel;
import craterstudio.util.concur.ConcurrentQueue;
import craterstudio.util.concur.SimpleBlockingQueue;
import craterstudio.util.concur.SimpleCountDownLatch;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingUtil {
    public static JDialog createDialogFromWindowAncestor(Component c) {
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w instanceof Frame) {
            return new JDialog((Frame)w);
        }
        if (w instanceof Dialog) {
            return new JDialog((Dialog)w);
        }
        throw new IllegalStateException(String.valueOf(w));
    }

    public static void addRecursiveMouseEnterExitListener(Container target, FocusListener listener) {
        class MouseHandler
        extends MouseAdapter
        implements MouseMotionListener {
            private boolean wasInside = false;
            private final /* synthetic */ Container val$target;
            private final /* synthetic */ FocusListener val$listener;

            MouseHandler(Container container, FocusListener focusListener) {
                this.val$target = container;
                this.val$listener = focusListener;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.handle(e);
            }

            void handle(MouseEvent e) {
                Point p = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.val$target);
                boolean isInside = this.val$target.contains(p);
                if (isInside == this.wasInside) {
                    return;
                }
                this.wasInside = isInside;
                if (isInside) {
                    this.val$listener.focusGained(null);
                } else {
                    this.val$listener.focusLost(null);
                }
            }
        }
        MouseHandler handler = new MouseHandler(target, listener);
        Component[] componentArray = SwingUtil.getComponentHierarchy(target);
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.addMouseListener(handler);
            c.addMouseMotionListener(handler);
            ++n2;
        }
    }

    public static Component[] getComponentHierarchy(Component c) {
        ArrayList<Component> list = new ArrayList<Component>();
        SwingUtil.getComponentHierarchy(c, list);
        return list.toArray(new Component[list.size()]);
    }

    private static void getComponentHierarchy(Component c, List<Component> fill) {
        fill.add(c);
        if (c instanceof Container) {
            Component[] componentArray = ((Container)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                SwingUtil.getComponentHierarchy(child, fill);
                ++n2;
            }
        }
    }

    public static void setChildrenOpaque(Component c, boolean opaque) {
        Component[] componentArray = SwingUtil.getComponentHierarchy(c);
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            if (child instanceof JComponent) {
                ((JComponent)child).setOpaque(opaque);
            }
            ++n2;
        }
    }

    public static void remove(Component c) {
        Container holder = c.getParent();
        holder.remove(c);
        SwingUtil.updateUI((Component)holder, true);
    }

    public static void invalidateChildren(Container c) {
        Component[] componentArray = c.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof Container) {
                SwingUtil.invalidateChildren((Container)comp);
            }
            comp.invalidate();
            ++n2;
        }
    }

    public static void simpleUpdate(Component c) {
        c.invalidate();
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w == null) {
            return;
        }
        w.validate();
    }

    public static void updateUI(Component comp, boolean bubbleUp) {
        if (bubbleUp) {
            SwingUtil.updateUI(comp, false, false);
            Window ancestor = SwingUtilities.getWindowAncestor(comp);
            if (ancestor != null) {
                ancestor.pack();
                return;
            }
        }
        SwingUtil.updateUI(comp, bubbleUp, true);
    }

    public static void updateUI(Component comp, int bubbleUps) {
        SwingUtil.updateUI(comp, bubbleUps, true);
    }

    public static void updateUI(Component comp, boolean bubbleUp, boolean packRoot) {
        SwingUtil.updateUI(comp, bubbleUp ? Integer.MAX_VALUE : 0, packRoot);
    }

    public static void updateUI(Component comp, int bubbleUps, boolean packRoot) {
        SwingUtil.checkOnEDT();
        if (comp instanceof Window) {
            Window w = (Window)comp;
            if (packRoot) {
                w.pack();
            } else {
                Component[] componentArray = w.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component child = componentArray[n2];
                    child.validate();
                    ++n2;
                }
            }
            return;
        }
        comp.invalidate();
        if (bubbleUps > 0 && comp.getParent() != null) {
            SwingUtil.updateUI((Component)comp.getParent(), bubbleUps - 1);
        } else {
            comp.validate();
            comp.repaint();
        }
    }

    public static boolean sync(final BooleanCallable task) {
        return SwingUtil.sync(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return task.call();
            }
        });
    }

    public static <T> T sync(final Callable<T> task) {
        final SimpleBlockingQueue queue = new SimpleBlockingQueue(1);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    queue.put(task.call());
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            }
        };
        SwingUtil.sync(run);
        return (T)queue.take();
    }

    public static void sync(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
            catch (InvocationTargetException exc) {
                throw new RuntimeException(exc.getCause());
            }
        }
    }

    public static void sync() {
        SwingUtil.sync(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public static void invoke(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    public static void invokeIf(final BooleanProducer condition, final Runnable task, int interval) {
        final Timer timer = new Timer(interval, null);
        timer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (condition.produce()) {
                    task.run();
                    timer.stop();
                }
            }
        });
        timer.setInitialDelay(0);
        timer.setDelay(interval);
        timer.setRepeats(true);
        timer.start();
    }

    public static void invokeAfter(final Runnable task, int delay) {
        Timer timer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                task.run();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public static <T> void callback(final SwingCallback<T> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        try {
                            final Object result = callback.async();
                            SwingUtil.sync(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onResult(result);
                                }
                            });
                        }
                        catch (Throwable cause) {
                            SwingUtil.sync(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onFailure(cause);
                                }
                            });
                            SwingUtil.sync(new Runnable(callback){
                                private final /* synthetic */ SwingCallback val$callback;
                                {
                                    this.val$callback = swingCallback;
                                }

                                @Override
                                public void run() {
                                    this.val$callback.finished();
                                }
                            });
                            break block5;
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtil.sync(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtil.sync(new /* invalid duplicate definition of identical inner class */);
                }
            }
        }).start();
    }

    public static void checkNotOnEDT() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must NOT be invoked from EDT");
        }
    }

    public static void checkOnEDT() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("must be invoked from EDT");
        }
    }

    public static SimpleCountDownLatch invokeSequence(final ConcurrentQueue<ScheduledInvocation> scheduled) {
        final SimpleCountDownLatch latch = new SimpleCountDownLatch();
        new Thread(){

            @Override
            public void run() {
                ScheduledInvocation curr;
                while ((curr = (ScheduledInvocation)scheduled.consume()) != null) {
                    HighLevel.sleep(curr.delay);
                    SwingUtil.sync(curr.task);
                    SwingUtil.sync();
                }
                SwingUtil.sync(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
            }
        }.start();
        return latch;
    }

    public static <T> Timer schedule(final BoundTask<T> task, final T target, final long delay, final long duration, long interval) {
        Asserts.assertNotNull(task);
        Asserts.assertNotNull(target);
        Asserts.assertPositive((long)((int)delay));
        Asserts.assertPositive((long)((int)duration));
        Asserts.assertPositive((long)((int)interval));
        final Timer timer = new Timer(0, null);
        timer.setInitialDelay((int)delay);
        timer.setDelay((int)interval);
        timer.setCoalesce(false);
        timer.addActionListener(new ActionListener(){
            long t0;
            long t1;
            int state = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                long now = Clock.now();
                switch (this.state) {
                    case 0: {
                        this.t0 = Clock.now() + delay;
                        this.t1 = this.t0 + duration;
                        task.begin(target);
                        ++this.state;
                        break;
                    }
                    case 1: {
                        task.step(target, this.t0, this.t0, this.t1);
                        ++this.state;
                        break;
                    }
                    case 2: {
                        if (now >= this.t1) {
                            task.step(target, this.t1, this.t0, this.t1);
                            ++this.state;
                            break;
                        }
                        task.step(target, now, this.t0, this.t1);
                        break;
                    }
                    case 3: {
                        task.end(target);
                        ++this.state;
                        timer.stop();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        });
        return timer;
    }

    public static SimpleCountDownLatch startTimerQueue(final ConcurrentQueue<Timer> timers) {
        final SimpleCountDownLatch latch = new SimpleCountDownLatch();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Timer current;
                while ((current = (Timer)timers.consume()) != null) {
                    current.start();
                    while (current.isRunning()) {
                        HighLevel.sleep(1L);
                    }
                }
                latch.countDown();
            }
        }).start();
        return latch;
    }

    public static class ScheduledInvocation {
        final Runnable task;
        final long delay;

        public ScheduledInvocation(Runnable task) {
            this(task, 0L);
        }

        public ScheduledInvocation(Runnable task, long delay) {
            this.task = task;
            this.delay = delay;
        }
    }
}

