/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import craterstudio.misc.gui.TextPaneUndo;
import craterstudio.text.Text;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class CssTextPane {
    private final StyledDocument doc;
    private final Style root;
    final JTextPane textPane = new JTextPane();
    final List<SyntaxElement> elements;

    public CssTextPane() {
        this.doc = this.textPane.getStyledDocument();
        this.root = this.doc.addStyle("root", StyleContext.getDefaultStyleContext().getStyle("default"));
        this.elements = new ArrayList<SyntaxElement>();
    }

    public void addSyntaxElement(String styleName, String pattern, int matchGroup) {
        this.elements.add(new SyntaxElement(styleName, pattern, matchGroup));
    }

    public String getText() {
        return this.textPane.getText();
    }

    public void setText(String text) {
        this.textPane.setText(text);
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public JScrollPane wrapInScrollPane() {
        return this.wrapInScrollPane(-1, -1);
    }

    public JScrollPane wrapInScrollPane(int w, int h) {
        JScrollPane scroller = new JScrollPane(this.textPane);
        scroller.setHorizontalScrollBarPolicy(30);
        scroller.setVerticalScrollBarPolicy(20);
        if (w != -1 && h != -1) {
            scroller.setPreferredSize(new Dimension(w, h));
        }
        return scroller;
    }

    public void defineStyles(String css) {
        if ((css = css.trim()).isEmpty()) {
            return;
        }
        String[] stringArray = Text.split(css, '}');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!(part = part.trim()).isEmpty()) {
                this.defineStyle(String.valueOf(part) + '}');
            }
            ++n2;
        }
    }

    public Style defineStyle(String css) {
        return this.defineStyle(Text.before(css, '{').trim(), Text.between(css, '{', '}').trim());
    }

    public Style defineStyle(String name, String props) {
        Style style = null;
        if (name.equals("*")) {
            style = this.root;
        } else {
            style = this.doc.getStyle(name);
            if (style == null) {
                style = this.doc.addStyle(name, this.root);
            }
        }
        String[] stringArray = Text.split(props, ';');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!(part = part.trim()).isEmpty()) {
                String[] keyval = Text.splitPair(part, ':');
                if (keyval == null) {
                    this.logIssue("invalid property definition: [" + part + "]");
                } else {
                    String key = keyval[0].trim();
                    String val = keyval[1].trim();
                    if (key.isEmpty() || val.isEmpty()) {
                        this.logIssue("invalid property definition: [" + part + "]");
                    } else {
                        this.setStyleProperty(style, key, val);
                    }
                }
            }
            ++n2;
        }
        return style;
    }

    public void setStyleProperty(Style style, String property, String value) {
        if (property.equals("font-family")) {
            StyleConstants.setFontFamily(style, value);
        } else if (property.equals("font-size")) {
            StyleConstants.setFontSize(style, Integer.parseInt(Text.replace(value, "pt", "")));
        } else if (property.equals("font-weight")) {
            StyleConstants.setBold(style, value.equals("bold"));
        } else if (property.equals("font-style")) {
            StyleConstants.setItalic(style, value.equals("italic"));
        } else if (property.equals("color")) {
            Color color = this.parseColor(value);
            if (color != null) {
                StyleConstants.setForeground(style, color);
            }
        } else if (property.equals("background") || property.equals("background-color")) {
            Color color = this.parseColor(value);
            if (color != null) {
                StyleConstants.setBackground(style, color);
            }
        } else if (property.equals("text-decoration")) {
            StyleConstants.setUnderline(style, false);
            StyleConstants.setStrikeThrough(style, false);
            String[] stringArray = Text.split(Text.removeDuplicates(value, ' '), ' ');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (!part.equals("none")) {
                    if (part.equals("underline")) {
                        StyleConstants.setUnderline(style, true);
                    } else if (part.equals("line-through")) {
                        StyleConstants.setStrikeThrough(style, true);
                    } else {
                        this.logIssue("unexpected style property: '" + property + "'");
                    }
                }
                ++n2;
            }
        } else {
            this.logIssue("unexpected style property: '" + property + "'");
        }
    }

    private Color parseColor(String value) {
        int rgba;
        if (!value.startsWith("#")) {
            this.logIssue("failed to parse color: '" + value + "'");
            return null;
        }
        if ((value = Text.after(value, "#")).length() == 3) {
            char[] hex = new char[6];
            int i = 0;
            while (i < hex.length) {
                hex[i] = value.charAt(i >> 1);
                ++i;
            }
            value = new String(hex);
        }
        try {
            rgba = Integer.parseInt(value, 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.logIssue("failed to parse hex color: '#" + value + "'");
            return null;
        }
        return new Color(rgba, value.length() == 8);
    }

    private final void logIssue(String issue) {
        System.err.println(String.valueOf(this.getClass().getSimpleName()) + " :: " + issue);
    }

    public final void activateAutoRestyle() {
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CssTextPane.this.restyle();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CssTextPane.this.restyle();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public final DocumentListener activateUndoRedo() {
        final TextPaneUndo undoSupport = new TextPaneUndo(this.textPane);
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control Z"), "Undo");
        this.textPane.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                undoSupport.undo();
            }
        });
        this.textPane.getInputMap().put(KeyStroke.getKeyStroke("control Y"), "Redo");
        this.textPane.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                undoSupport.redo();
            }
        });
        return undoSupport.register();
    }

    public final void restyle() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = CssTextPane.this.textPane.getText();
                String normalized = Text.normalizeLinebreaks(text);
                CssTextPane.this.clearStyles();
                CssTextPane.this.applyStyleOnRange("root", 0, CssTextPane.this.textPane.getDocument().getLength());
                for (SyntaxElement element : CssTextPane.this.elements) {
                    Matcher matcher = element.pattern.matcher(normalized);
                    while (matcher.find()) {
                        CssTextPane.this.applyStyleOnMatch(element.styleName, matcher, element.group);
                    }
                }
            }
        });
    }

    public void clearStyles() {
        StyledDocument doc = this.textPane.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        doc.setCharacterAttributes(0, doc.getLength(), style, true);
    }

    public void applyStyleOnRange(String styleName, int off, int end) {
        StyledDocument doc = this.textPane.getStyledDocument();
        doc.setCharacterAttributes(off, end - off, doc.getStyle(styleName), false);
    }

    public void applyStyleOnMatch(String styleName, Matcher matcher) {
        this.applyStyleOnRange(styleName, matcher.start(), matcher.end());
    }

    public void applyStyleOnMatch(String styleName, Matcher matcher, int group) {
        this.applyStyleOnRange(styleName, matcher.start(group), matcher.end(group));
    }

    public void applyStyleOnLine(String styleName, int lineNumber) {
        String text = Text.normalizeLinebreaks(this.textPane.getText());
        int lineCounter = 0;
        int lastNewLine = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\n') {
                if (lineNumber != ++lineCounter) {
                    lastNewLine = i;
                } else {
                    this.applyStyleOnRange(styleName, lastNewLine, i);
                    break;
                }
            }
            ++i;
        }
    }

    private static class SyntaxElement {
        Pattern pattern;
        int group;
        String styleName;

        public SyntaxElement(String styleName, String regex, int group) {
            this.pattern = Pattern.compile(regex, 8);
            this.group = group;
            this.styleName = styleName;
        }
    }
}

