/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import craterstudio.misc.gui.SwingUtil;
import craterstudio.text.Text;
import craterstudio.util.concur.ConcurrentQueue;
import craterstudio.util.concur.SimpleCountDownLatch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class UserIO {
    static CustomUncaughtExceptionHandler excHandler;

    static {
        UserIO.setSystemLookAndFeel();
        excHandler = new CustomUncaughtExceptionHandler();
    }

    public static final void setSystemLookAndFeel() {
        try {
            String curLAF = UIManager.getLookAndFeel().getClass().getName();
            String newLAF = UIManager.getSystemLookAndFeelClassName();
            if (!curLAF.equals(newLAF)) {
                UIManager.setLookAndFeel(newLAF);
            }
        }
        catch (Exception exception) {}
    }

    public static File fileDialog(Component c, boolean forLoad, String showDir, String suggestFilename) {
        FileDialog fd;
        Window window = SwingUtilities.getWindowAncestor(c);
        if (window instanceof Frame) {
            fd = new FileDialog((Frame)window, "FileDialog", forLoad ? 0 : 1);
        } else if (window instanceof Dialog) {
            fd = new FileDialog((Dialog)window, "FileDialog", forLoad ? 0 : 1);
        } else {
            throw new IllegalStateException();
        }
        fd.pack();
        fd.setLocationRelativeTo(window);
        fd.setDirectory(showDir);
        fd.setFile(suggestFilename);
        fd.setVisible(true);
        String dir = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return null;
        }
        File file = new File(dir == null ? "./" : dir, filename);
        if (forLoad && !file.exists()) {
            return null;
        }
        return file;
    }

    public static void installErrorHandler(String appName) {
        excHandler.newThread(appName);
        Thread.setDefaultUncaughtExceptionHandler(excHandler);
        System.setProperty("sun.awt.exception.handler", AWTExceptionHandler.class.getName());
    }

    public static JFrame createDefaultFrame(Container container) {
        return UserIO.createDefaultFrame(container, "", true);
    }

    public static JFrame createDefaultFrame(Container container, String title, boolean resizable) {
        return UserIO.createDefaultFrame(container, title, resizable, true);
    }

    public static JFrame createDefaultFrame(Container container, String title, boolean resizable, boolean visible) {
        return UserIO.createDefaultFrame(container, title, resizable, visible, true);
    }

    public static JFrame createDefaultFrame(Container container, String title, boolean resizable, boolean visible, boolean closeExit) {
        JFrame frame = new JFrame();
        frame.setTitle(title);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)container, "Center");
        frame.setResizable(resizable);
        frame.pack();
        frame.setLocationRelativeTo(null);
        try {
            frame.setDefaultCloseOperation(closeExit ? 3 : 2);
        }
        catch (SecurityException securityException) {
            frame.setDefaultCloseOperation(2);
        }
        frame.setVisible(visible);
        return frame;
    }

    public static JDialog createDefaultDialog(Container container) {
        return UserIO.createDefaultDialog(container, "Dialog", false);
    }

    public static JDialog createDefaultDialog(Container container, String title, boolean resizable) {
        return UserIO.createDefaultDialog(container, title, resizable, null);
    }

    public static JDialog createDefaultDialog(Container container, String title, boolean resizable, Container parent) {
        return UserIO.createDefaultDialog(container, title, true, resizable, parent);
    }

    public static JDialog createDefaultDialog(Container container, String title, boolean modal, boolean resizable, Container parent) {
        JDialog dialog = parent == null ? new JDialog(null) : SwingUtil.createDialogFromWindowAncestor(parent);
        dialog.setTitle(title);
        dialog.setModal(modal);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)container, "Center");
        dialog.setResizable(resizable);
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setDefaultCloseOperation(2);
        return dialog;
    }

    public static final void say(Component c, String title, String line) {
        if (title == null || title.isEmpty()) {
            title = "Message";
        }
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(c), line, " " + title, 1);
    }

    public static final void say(String title, String line) {
        JFrame frame = new JFrame();
        UserIO.say(frame, title, line);
        frame.dispose();
    }

    public static final void warn(Component c, String title, String line) {
        if (title == null || title.isEmpty()) {
            title = "Warning";
        }
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(c), line, " " + title, 2);
    }

    public static final void warn(String title, String line) {
        JFrame frame = new JFrame();
        UserIO.warn(frame, title, line);
        frame.dispose();
    }

    public static final void alert(Component c, String title, String line) {
        if (title == null || title.isEmpty()) {
            title = "Alert";
        }
        JOptionPane.showMessageDialog(SwingUtilities.getRoot(c), line, " " + title, 0);
    }

    public static final void alert(String title, String line) {
        JFrame frame = new JFrame();
        UserIO.alert(frame, title, line);
        frame.dispose();
    }

    public static final boolean ask(Component c, String title, String line) {
        if (title == null || title.isEmpty()) {
            title = "Question";
        }
        if (line.contains("\n")) {
            line = String.valueOf(line) + "\n";
        }
        return JOptionPane.showConfirmDialog(SwingUtilities.getRoot(c), line, " " + title, 0) == 0;
    }

    public static final boolean ask(String title, String line) {
        JFrame frame = new JFrame();
        boolean value = UserIO.ask(frame, title, line);
        frame.dispose();
        return value;
    }

    public static final String question(Component c, String title, String line) {
        return UserIO.question(c, title, line, "");
    }

    public static final String question(Component c, String title, String line, String defaultInput) {
        if (title == null || title.isEmpty()) {
            title = "Question";
        }
        return (String)JOptionPane.showInputDialog(SwingUtilities.getRoot(c), line, " " + title, 3, null, null, defaultInput);
    }

    public static final String question(String title, String line) {
        JFrame frame = new JFrame();
        String value = UserIO.question(frame, title, line);
        frame.dispose();
        return value;
    }

    public static final String password(Component c, String title, String line, String defaultInput) {
        if (title == null || title.isEmpty()) {
            title = "Password";
        }
        JPasswordField pwd = new JPasswordField(defaultInput, 10);
        JPanel holder = new JPanel(new BorderLayout());
        holder.add((Component)new JLabel(line), "North");
        holder.add((Component)pwd, "South");
        int action = JOptionPane.showConfirmDialog(SwingUtilities.getRoot(c), holder, " " + title, 2, 3);
        if (action != 0) {
            return null;
        }
        return new String(pwd.getPassword());
    }

    public static final SimpleCountDownLatch blockUI(Component c) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Cannot block UI from EDT");
        }
        final Component root = SwingUtilities.getRoot(c);
        final SimpleCountDownLatch dialogSignal = new SimpleCountDownLatch();
        final Dialog[] dialog = new Dialog[1];
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (root instanceof Frame) {
                    dialog[0] = new Dialog((Frame)root, "blocker", true);
                } else if (root instanceof Window) {
                    dialog[0] = new Dialog((Dialog)root, "blocker", true);
                } else {
                    throw new IllegalStateException("root not a frame or dialog");
                }
                dialog[0].setSize(128, 128);
                dialog[0].setLocation(-256, -256);
                dialog[0].setVisible(true);
                dialogSignal.countDown();
            }
        });
        final SimpleCountDownLatch userSignal = new SimpleCountDownLatch();
        new Thread(new Runnable(){

            @Override
            public void run() {
                dialogSignal.await();
                userSignal.await();
                dialog[0].dispose();
            }
        });
        return userSignal;
    }

    static String throwableDescription(Throwable t) {
        String type = t.getClass().getSimpleName();
        type = Text.beforeIfAny(type, "Exception");
        type = Text.beforeIfAny(type, "Error");
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < type.length()) {
            if (i != 0 && Character.isUpperCase(type.charAt(i))) {
                sb.append(' ').append(Character.toLowerCase(type.charAt(i)));
            } else {
                sb.append(type.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static class AWTExceptionHandler {
        public void handle(Throwable t) {
            try {
                excHandler.uncaughtException(Thread.currentThread(), t);
            }
            catch (Throwable throwable) {}
        }
    }

    static class CustomUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        final ConcurrentQueue<Throwable> crashListener = new ConcurrentQueue(false);

        CustomUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            System.out.print("Exception in thread \"" + t.getName() + "\" ");
            e.printStackTrace(System.err);
            try {
                this.crashListener.produce(e);
            }
            catch (Throwable throwable) {}
        }

        void newThread(final String appName) {
            Thread crashThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        Throwable t = CustomUncaughtExceptionHandler.this.crashListener.consume();
                        String dialog = "";
                        dialog = String.valueOf(dialog) + appName + " has encountered an unexpected error:";
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "        Type: " + UserIO.throwableDescription(t);
                        if (t.getMessage() != null) {
                            dialog = String.valueOf(dialog) + "\r\n";
                            dialog = String.valueOf(dialog) + "        Message: " + t.getMessage();
                        }
                        if (t.getCause() != null) {
                            dialog = String.valueOf(dialog) + "\r\n";
                            dialog = String.valueOf(dialog) + "        Cause: " + UserIO.throwableDescription(t.getCause());
                        }
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "\r\n";
                        dialog = String.valueOf(dialog) + "Unfortunately the program must be terminated.";
                        Frame[] roots = Frame.getFrames();
                        Frame root = null;
                        if (roots != null && roots.length != 0) {
                            root = roots[0];
                        }
                        UserIO.alert(root, String.valueOf(appName) + " :: Fatal Error", dialog);
                        System.exit(0);
                    }
                }
            });
            crashThread.setDaemon(true);
            crashThread.start();
        }
    }
}

