/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.text;

import java.util.Calendar;

public class TextValues {
    private static char[] hexTableUpper = "0123456789ABCDEF".toCharArray();
    private static final String zeros = new String("0000000000000000000000000000000000");
    private static final String[] mags = new String[]{"n", "u", "m", "", "k", "M", "G", "T", "P"};

    public static boolean isBoolean(String value) {
        if (value == null) {
            return false;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        return value.equalsIgnoreCase("false");
    }

    public static boolean isInt(String value) {
        if (value == null) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isLong(String value) {
        if (value == null) {
            return false;
        }
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isFloat(String value) {
        if (value == null) {
            return false;
        }
        try {
            Float.parseFloat(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isDouble(String value) {
        if (value == null) {
            return false;
        }
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean tryParseBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static int tryParseInt(String value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static long tryParseLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static float tryParseFloat(String value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static double tryParseDouble(String value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static final String[] trim(String[] src) {
        String[] dst = new String[src.length];
        int i = 0;
        while (i < dst.length) {
            dst[i] = src[i].trim();
            ++i;
        }
        return dst;
    }

    public static final boolean[] parseBooleans(String[] value) {
        boolean[] data = new boolean[value.length];
        int i = 0;
        while (i < data.length) {
            if (value[i].equals("true")) {
                data[i] = true;
            } else if (value[i].equals("false")) {
                data[i] = false;
            } else {
                throw new IllegalArgumentException("value: " + value[i]);
            }
            ++i;
        }
        return data;
    }

    public static final long[] parseLongs(String[] value) {
        long[] data = new long[value.length];
        int i = 0;
        while (i < data.length) {
            data[i] = Long.parseLong(value[i], 10);
            ++i;
        }
        return data;
    }

    public static final double[] parseDoubles(String[] value) {
        double[] data = new double[value.length];
        int i = 0;
        while (i < data.length) {
            data[i] = Double.parseDouble(value[i]);
            ++i;
        }
        return data;
    }

    public static final int[] parseInts(String[] value) {
        return TextValues.parseInts(value, 0, value.length, 10);
    }

    public static final int[] parseInts(String[] value, int radix) {
        return TextValues.parseInts(value, 0, value.length, radix);
    }

    public static final int[] parseInts(String[] value, int off, int len) {
        return TextValues.parseInts(value, off, len, 10);
    }

    public static final int[] parseInts(String[] value, int off, int len, int radix) {
        int[] data = new int[len];
        int i = 0;
        while (i < len) {
            data[i] = Integer.parseInt(value[off + i], radix);
            ++i;
        }
        return data;
    }

    public static final float[] parseFloats(String[] value) {
        return TextValues.parseFloats(value, 0, value.length);
    }

    public static final float[] parseFloats(String[] value, int off, int len) {
        float[] data = new float[len];
        int i = 0;
        while (i < len) {
            data[i] = Float.parseFloat(value[off + i]);
            ++i;
        }
        return data;
    }

    public static final String nanosToTime(long nanos) {
        if (nanos == 0L) {
            return "n/a";
        }
        if (nanos < 10000L) {
            return String.valueOf(nanos) + "ns";
        }
        long micros = nanos / 1000L;
        if (micros < 10000L) {
            return String.valueOf(micros) + "us";
        }
        long millis = micros / 1000L;
        if (millis < 10000L) {
            return String.valueOf(millis) + "ms";
        }
        return String.valueOf(millis / 1000L) + "s";
    }

    public static final String nanosAsMicroSeconds(long nanos) {
        return String.valueOf(TextValues.formatNumber((double)nanos / 1.0E9, 6)) + "s";
    }

    public static final String valueOf(int[] buf) {
        return TextValues.valueOf(buf, 0, buf.length);
    }

    public static final String valueOf(float[] buf) {
        return TextValues.valueOf(buf, 0, buf.length);
    }

    public static final String valueOf(int[] buf, int off, int len) {
        if (len == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            buffer.append(buf[off + i]);
            buffer.append(", ");
            ++i;
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }

    public static final String valueOf(float[] buf, int off, int len) {
        if (len == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < len) {
            buffer.append(buf[off + i]);
            buffer.append(", ");
            ++i;
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }

    private static final int h2i(int cur) {
        if (cur >= 48 && cur <= 57) {
            return cur - 48;
        }
        if (cur >= 97 && cur <= 102) {
            return cur - 97 + 10;
        }
        if (cur >= 65 && cur <= 70) {
            return cur - 65 + 10;
        }
        throw new IllegalArgumentException("cur=" + cur);
    }

    public static final String hexDecode(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] digits = new char[hex.length() / 2];
        int k = 0;
        int p = 0;
        while (k < digits.length) {
            digits[k] = (char)(TextValues.h2i(hex.charAt(p++)) << 4 | TextValues.h2i(hex.charAt(p++)));
            ++k;
        }
        return new String(digits);
    }

    public static final String hexEncode(String str) {
        if (str == null) {
            return null;
        }
        char[] hex = new char[str.length() * 2];
        int i = 0;
        int p = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            hex[p + 0] = hexTableUpper[(c & 0xF0) >> 4];
            hex[p + 1] = hexTableUpper[(c & 0xF) >> 0];
            ++i;
            p += 2;
        }
        return new String(hex);
    }

    public static int hexDecodeDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new IllegalStateException();
    }

    public static final String hexRawEncode(byte[] raw) {
        char[] ca = new char[raw.length * 2];
        int i = 0;
        while (i < raw.length) {
            int k = 0;
            while (k < 2) {
                ca[(i << 1) + (1 - k)] = hexTableUpper[(raw[i] & 0xFF) >>> (k << 2) & 0xF];
                ++k;
            }
            ++i;
        }
        return new String(ca);
    }

    public static final byte[] hexRawDecode(String raw) {
        if (raw.length() % 2 != 0) {
            throw new IllegalStateException();
        }
        byte[] data = new byte[raw.length() >> 1];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)Integer.parseInt(raw.substring(i << 1, (i << 1) + 2), 16);
            ++i;
        }
        return data;
    }

    public static final String hexValueOf(byte hex) {
        char[] digits = new char[2];
        int i = 0;
        while (i < 2) {
            digits[1 - i] = hexTableUpper[hex >>> (i << 2) & 0xF];
            ++i;
        }
        return new String(digits);
    }

    public static final String hexValueOf(short hex) {
        char[] digits = new char[4];
        int i = 0;
        while (i < 4) {
            digits[3 - i] = hexTableUpper[hex >>> (i << 2) & 0xF];
            ++i;
        }
        return new String(digits);
    }

    public static final String hexValueOf(int hex) {
        char[] digits = new char[8];
        int i = 0;
        while (i < 8) {
            digits[7 - i] = hexTableUpper[hex >>> (i << 2) & 0xF];
            ++i;
        }
        return new String(digits);
    }

    public static final String hexValueOf(long hex) {
        char[] digits = new char[16];
        int i = 0;
        while (i < 16) {
            digits[15 - i] = hexTableUpper[(int)(hex >>> (i << 2)) & 0xF];
            ++i;
        }
        return new String(digits);
    }

    public static final String binValueOf(byte hex) {
        char[] digits = new char[8];
        int i = 0;
        while (i < 8) {
            digits[7 - i] = (char)(48 + (hex >>> i & 1));
            ++i;
        }
        return new String(digits);
    }

    public static final String binValueOf(short hex) {
        char[] digits = new char[3216];
        int i = 0;
        while (i < 16) {
            digits[15 - i] = (char)(48 + (hex >>> i & 1));
            ++i;
        }
        return new String(digits);
    }

    public static final String binValueOf(int hex) {
        char[] digits = new char[32];
        int i = 0;
        while (i < 32) {
            digits[31 - i] = (char)(48 + (hex >>> i & 1));
            ++i;
        }
        return new String(digits);
    }

    public static final String binValueOf(long hex) {
        char[] digits = new char[64];
        int i = 0;
        while (i < 64) {
            digits[63 - i] = (char)(48L + (hex >>> i & 1L));
            ++i;
        }
        return new String(digits);
    }

    public static final int parseIntMagnitude(String s) {
        long value = TextValues.parseLongMagnitude(s);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new IllegalStateException("value too large too fit in integer");
        }
        return (int)value;
    }

    public static final long parseLongMagnitude(String s) {
        if ((s = s.trim()).isEmpty()) {
            return 0L;
        }
        long mul = 1L;
        switch (s.charAt(s.length() - 1)) {
            case 'T': {
                mul *= 1024L;
            }
            case 'G': {
                mul *= 1024L;
            }
            case 'M': {
                mul *= 1024L;
            }
            case 'K': {
                mul *= 1024L;
                break;
            }
            case 'y': {
                mul *= 365L;
            }
            case 'w': {
                mul *= 7L;
            }
            case 'd': {
                mul *= 24L;
            }
            case 'h': {
                mul *= 60L;
            }
            case 'm': {
                mul *= 60L;
            }
            case 's': {
                mul *= 1000L;
                break;
            }
        }
        if (mul != 1L) {
            s = s.substring(0, s.length() - 1);
        }
        return Long.parseLong(s) * mul;
    }

    public static final String magnitudePeriods(int value, char sep) {
        boolean neg;
        boolean bl = neg = value < 0;
        if (neg) {
            value = -value;
        }
        String left = String.valueOf(value);
        String build = "";
        while (left.length() > 3) {
            build = String.valueOf(sep) + left.substring(left.length() - 3) + build;
            left = left.substring(0, left.length() - 3);
        }
        return String.valueOf(neg ? "-" : "") + left + build;
    }

    public static final String formatCurrencyInCents(int amount, boolean formatForUSD, boolean magnitudeSeparators) {
        int full = amount / 100;
        int cent = amount % 100;
        char mags = formatForUSD ? (char)',' : '.';
        char sepe = formatForUSD ? (char)'.' : ',';
        String post = String.valueOf(sepe) + TextValues.formatNumber(cent, 2);
        if (magnitudeSeparators) {
            return String.valueOf(TextValues.magnitudePeriods(full, mags)) + post;
        }
        return String.valueOf(String.valueOf(full)) + post;
    }

    public static final String formatNumber(int value, int minbfor) {
        String s;
        boolean negative = value < 0;
        String sign = "";
        if (negative) {
            sign = "-";
            value = -value;
        }
        if ((s = String.valueOf(value)).length() < minbfor) {
            s = String.valueOf(zeros.substring(0, minbfor - s.length())) + s;
        }
        return String.valueOf(sign) + s;
    }

    public static final String formatNumber(double value, int minbfor, int decimals) {
        boolean negative;
        boolean bl = negative = value < 0.0;
        if (negative) {
            value = -value;
        }
        String s = TextValues.formatNumber(value, decimals);
        StringBuffer buffer = new StringBuffer();
        int bfor = s.indexOf(46);
        if (bfor == -1) {
            bfor = s.length();
        }
        int nbfor = minbfor - bfor;
        if (negative) {
            buffer.append("-");
            --nbfor;
        }
        if (nbfor > 0) {
            buffer.append(zeros.substring(0, nbfor));
        }
        buffer.append(s);
        return buffer.toString();
    }

    public static final String formatedValueOf(float[] value, int before, int after) {
        if (value.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            buffer.append(TextValues.formatNumber(value[i], before, after));
            buffer.append(", ");
            ++i;
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }

    public static final String formatNumber(double value, int decimals) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        double multiply = Math.pow(10.0, decimals);
        value *= multiply;
        value = Math.round(value);
        StringBuffer buffer = new StringBuffer();
        long full = (long)(value /= multiply);
        buffer.append(full);
        buffer.append('.');
        if (full < 0L) {
            full = -full;
        }
        value -= (double)full;
        int i = 0;
        while (i < decimals) {
            int digit = (int)(value *= 10.0);
            buffer.append(Math.min(9, digit));
            value -= (double)digit;
            ++i;
        }
        return buffer.toString();
    }

    public static final String formatWithMagnitude(double value, int decimals) {
        return TextValues.formatWithMagnitude(value, decimals, 1000.0);
    }

    public static final String formatWithMagnitudeBytes(double value, int decimals) {
        return TextValues.formatWithMagnitude(value, decimals, 1024.0);
    }

    private static final String formatWithMagnitude(double value, int decimals, double magSize) {
        boolean minus;
        if (value == 0.0) {
            return TextValues.formatNumber(value, decimals);
        }
        int mag = 3;
        boolean bl = minus = value < 0.0;
        if (minus) {
            value = -value;
        }
        if (value > 1.0) {
            while (value / magSize > 1.0) {
                ++mag;
                value /= magSize;
            }
        } else {
            do {
                --mag;
            } while ((value *= magSize) * magSize < 1.0);
        }
        if (minus) {
            value = -value;
        }
        return String.valueOf(TextValues.formatNumber(value, decimals)) + mags[mag];
    }

    public static final String getCurrentDate() {
        return TextValues.formatDateTime(System.currentTimeMillis(), "Y-M-D");
    }

    public static final String getCurrentTime() {
        return TextValues.formatDateTime(System.currentTimeMillis(), "h:m:s");
    }

    public static final String getCurrentDateTime() {
        return TextValues.formatDateTime(System.currentTimeMillis(), "Y-M-D h:m:s");
    }

    public static final String formatDateTime(long timestamp, String format) {
        Calendar cc = Calendar.getInstance();
        cc.setTimeInMillis(timestamp);
        int yyyy = cc.get(1);
        int mm = cc.get(2) + 1;
        int dd = cc.get(5);
        int h = cc.get(11);
        int m = cc.get(12);
        int s = cc.get(13);
        int ms = cc.get(14);
        String yyyy0 = TextValues.formatNumber(yyyy, 4, 0);
        String mm0 = TextValues.formatNumber(mm, 2, 0);
        String dd0 = TextValues.formatNumber(dd, 2, 0);
        String h0 = TextValues.formatNumber(h, 2, 0);
        String m0 = TextValues.formatNumber(m, 2, 0);
        String s0 = TextValues.formatNumber(s, 2, 0);
        String ms0 = TextValues.formatNumber(ms, 3, 0);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < format.length()) {
            switch (format.charAt(i)) {
                case 'Y': {
                    sb.append(yyyy0);
                    break;
                }
                case 'M': {
                    sb.append(mm0);
                    break;
                }
                case 'D': {
                    sb.append(dd0);
                    break;
                }
                case 'h': {
                    sb.append(h0);
                    break;
                }
                case 'm': {
                    sb.append(m0);
                    break;
                }
                case 's': {
                    sb.append(s0);
                    break;
                }
                case 'S': {
                    sb.append(ms0);
                    break;
                }
                default: {
                    sb.append(format.charAt(i));
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String formatElapsedTime(long ms, String format) {
        long s = ms / 1000L;
        long ss = s % 60L;
        long mm = s / 60L % 60L;
        long hh = s / 60L / 60L;
        String ss0 = TextValues.formatNumber(ss, 2, 0);
        String mm0 = TextValues.formatNumber(mm, 2, 0);
        String hh0 = TextValues.formatNumber(hh, 2, 0);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < format.length()) {
            switch (format.charAt(i)) {
                case 'S': {
                    sb.append(ss0);
                    break;
                }
                case 'M': {
                    sb.append(mm0);
                    break;
                }
                case 'H': {
                    sb.append(hh0);
                    break;
                }
                default: {
                    sb.append(format.charAt(i));
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

