/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.misc.gui;

import craterstudio.misc.gui.SwingUtil;
import java.util.LinkedList;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextPaneUndo {
    final JTextPane textPane;
    private boolean isBusy;
    private final LinkedList<Snapshot> undoStack;
    private final LinkedList<Snapshot> redoStack;
    private final int maxHistory;

    public TextPaneUndo(JTextPane textPane) {
        this.textPane = textPane;
        this.maxHistory = 256;
        this.isBusy = false;
        this.redoStack = new LinkedList();
        this.undoStack = new LinkedList();
        this.undoStack.addFirst(new Snapshot(false));
    }

    public final DocumentListener register() {
        DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextPaneUndo.this.onEvent(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextPaneUndo.this.onEvent(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textPane.getDocument().addDocumentListener(listener);
        return listener;
    }

    public void onEvent(boolean isInsertEvent) {
        SwingUtil.checkOnEDT();
        if (!this.isBusy) {
            this.redoStack.clear();
            this.undoStack.addFirst(new Snapshot(isInsertEvent));
            while (this.undoStack.size() > this.maxHistory) {
                this.undoStack.removeLast();
            }
        }
    }

    public final void undo() {
        SwingUtil.checkOnEDT();
        this.isBusy = true;
        try {
            String curr = this.textPane.getText();
            Snapshot undo = null;
            while (!this.undoStack.isEmpty()) {
                undo = this.undoStack.removeFirst();
                if (this.redoStack.isEmpty() || !this.redoStack.getFirst().text.equals(undo.text)) {
                    this.redoStack.addFirst(undo);
                }
                if (!undo.text.equals(curr)) break;
            }
            if (undo != null) {
                undo.restore();
            }
            this.undoStack.addFirst(new Snapshot(false));
        }
        finally {
            this.isBusy = false;
        }
    }

    public final void redo() {
        SwingUtil.checkOnEDT();
        this.isBusy = true;
        try {
            String curr = this.textPane.getText();
            Snapshot redo = null;
            while (!this.redoStack.isEmpty()) {
                redo = this.redoStack.removeFirst();
                if (this.undoStack.isEmpty() || !this.undoStack.getFirst().text.equals(redo.text)) {
                    this.undoStack.addFirst(redo);
                }
                if (!redo.text.equals(curr)) break;
            }
            if (redo != null) {
                redo.restore();
            }
        }
        finally {
            this.isBusy = false;
        }
    }

    private class Snapshot {
        final String text;
        final int caret;

        public Snapshot(boolean isInsertEvent) {
            this.text = TextPaneUndo.this.textPane.getText();
            int pos = TextPaneUndo.this.textPane.getCaretPosition();
            int len = TextPaneUndo.this.textPane.getDocument().getLength();
            this.caret = Math.min(pos + (isInsertEvent ? 1 : 0), len);
        }

        public void restore() {
            TextPaneUndo.this.textPane.setText(this.text);
            TextPaneUndo.this.textPane.setCaretPosition(this.caret);
        }
    }
}

