/*
 * Decompiled with CFR 0.152.
 */
package craterstudio.util.concur;

import craterstudio.util.HighLevel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ConcurrentQueue<T> {
    private final LinkedList<T> queue = new LinkedList();
    private final Object mutex = new Object();
    private final boolean doNotifyAll;

    public ConcurrentQueue(boolean doNotifyAll) {
        this.doNotifyAll = doNotifyAll;
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForEmpty() {
        Object object = this.mutex;
        synchronized (object) {
            while (!this.queue.isEmpty()) {
                HighLevel.wait(this.mutex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.queue.size();
        }
    }

    public final Object mutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void produce(T t) {
        Object object = this.mutex;
        synchronized (object) {
            this.queue.addLast(t);
            if (this.doNotifyAll) {
                this.mutex.notifyAll();
            } else {
                this.mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void produceFirst(T t) {
        Object object = this.mutex;
        synchronized (object) {
            this.queue.addFirst(t);
            if (this.doNotifyAll) {
                this.mutex.notifyAll();
            } else {
                this.mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> drain() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<T> list = new ArrayList<T>();
            while (!this.queue.isEmpty()) {
                list.add(this.queue.removeFirst());
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T consume() {
        Object object = this.mutex;
        synchronized (object) {
            while (this.queue.isEmpty()) {
                HighLevel.wait(this.mutex);
            }
            return this.queue.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T consume(long milliTimeout) {
        Object object = this.mutex;
        synchronized (object) {
            long began = System.currentTimeMillis();
            while (true) {
                if (!this.queue.isEmpty()) {
                    return this.queue.removeFirst();
                }
                long elapsed = System.currentTimeMillis() - began;
                if (elapsed > milliTimeout) {
                    return null;
                }
                HighLevel.wait(this.mutex, Math.max(1L, milliTimeout / 3L));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T peek() {
        Object object = this.mutex;
        synchronized (object) {
            block4: {
                if (!this.queue.isEmpty()) break block4;
                return null;
            }
            return this.queue.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T poll() {
        Object object = this.mutex;
        synchronized (object) {
            block4: {
                if (!this.queue.isEmpty()) break block4;
                return null;
            }
            return this.queue.removeFirst();
        }
    }
}

