/*
 * Decompiled with CFR 0.152.
 */
package eden.emulator.lmc;

import eden.emulator.EmulatorCrash;
import eden.emulator.EmulatorFeedback;

public class Lmc {
    public static final int HLT = 0;
    public static final int ADD = 1;
    public static final int SUB = 2;
    public static final int STA = 3;
    public static final int LDA = 5;
    public static final int BRA = 6;
    public static final int BRZ = 7;
    public static final int BRP = 8;
    public static final int UIO = 9;
    private int program_counter = 0;
    private int execute_counter = 0;
    private int last_reference = 0;
    private int last_program_counter = 0;
    private int[] memory = new int[100];
    private int boxInput = 0;
    private int boxOutput = 0;
    private int register;
    private boolean overflowFlag = false;

    public Lmc() {
        this.init();
    }

    public void load(int[] memory) {
        if (memory.length != this.memory.length) {
            throw new IllegalStateException("expected " + this.memory.length + " memory values");
        }
        int i = 0;
        while (i < memory.length) {
            if (memory[i] < 0 || memory[i] > 999) {
                throw new IllegalStateException("illegal memory value @" + i + ": " + memory[i]);
            }
            this.memory[i] = memory[i];
            ++i;
        }
        this.init();
    }

    public void init() {
        this.reset();
        this.execute_counter = 0;
    }

    public void reset() {
        this.boxInput = 0;
        this.boxOutput = 0;
        this.register = 0;
        this.overflowFlag = false;
        this.program_counter = 0;
        this.last_program_counter = -1;
        this.last_reference = -1;
    }

    public int getInstructionPointer() {
        return this.program_counter;
    }

    public int getLastInstructionPointer() {
        return this.last_program_counter;
    }

    public int getLastReference() {
        return this.last_reference;
    }

    public boolean getOverflowFlag() {
        return this.overflowFlag;
    }

    public int readInbox() {
        return this.boxInput;
    }

    public int readOutbox() {
        return this.boxOutput;
    }

    public int readRegister() {
        return this.register;
    }

    public int readMemory(int address) {
        return this.memory[address];
    }

    public int execute(EmulatorFeedback feedback) throws EmulatorCrash {
        int arg;
        int data = this.memory[this.program_counter];
        this.last_program_counter = this.program_counter++;
        ++this.execute_counter;
        int instruction = data / 100;
        this.last_reference = arg = data % 100;
        block0 : switch (instruction) {
            case 0: {
                this.last_reference = -1;
                if (arg != 0) {
                    feedback.invalidInstruction();
                    throw new EmulatorCrash();
                }
                this.reset();
                feedback.halt();
                break;
            }
            case 1: {
                int doAdd = this.memory[Lmc.checkAddress(arg, feedback)];
                this.register = this.normalizeRegister(this.register + doAdd);
                break;
            }
            case 2: {
                int doSub = this.memory[Lmc.checkAddress(arg, feedback)];
                this.register = this.normalizeRegister(this.register - doSub);
                break;
            }
            case 5: {
                this.register = this.memory[Lmc.checkAddress(arg, feedback)];
                break;
            }
            case 3: {
                this.memory[Lmc.checkAddress((int)arg, (EmulatorFeedback)feedback)] = this.register;
                break;
            }
            case 6: {
                this.program_counter = Lmc.checkAddress(arg, feedback);
                break;
            }
            case 7: {
                if (this.register != 0) break;
                this.program_counter = Lmc.checkAddress(arg, feedback);
                break;
            }
            case 8: {
                if (this.overflowFlag) break;
                this.program_counter = Lmc.checkAddress(arg, feedback);
                break;
            }
            case 9: {
                this.last_reference = -1;
                switch (arg) {
                    case 1: {
                        this.boxInput = feedback.input();
                        this.register = this.normalizeRegister(this.boxInput);
                        break block0;
                    }
                    case 2: {
                        this.boxOutput = this.register;
                        feedback.output(this.boxOutput);
                        break block0;
                    }
                }
                feedback.invalidInstruction();
                throw new EmulatorCrash();
            }
        }
        return data;
    }

    private int normalizeRegister(int value) {
        this.overflowFlag = value < 0 || value > 999;
        return (value % 1000 + 1000) % 1000;
    }

    private static int checkAddress(int addr, EmulatorFeedback feedback) throws EmulatorCrash {
        if (addr < 0 || addr >= 100) {
            feedback.invalidAddress(addr);
            throw new EmulatorCrash();
        }
        return addr;
    }
}

