/*
 * Decompiled with CFR 0.152.
 */
package eden.emulator.lmc;

import craterstudio.text.TextValues;
import eden.emulator.EmulatorCrash;
import eden.emulator.EmulatorFeedback;
import eden.emulator.lmc.Lmc;

public class LmcDebug {
    private final Lmc backing;

    public LmcDebug(Lmc backing) {
        if (backing == null) {
            throw new NullPointerException();
        }
        this.backing = backing;
    }

    public int execute(EmulatorFeedback feedback) throws EmulatorCrash {
        int data = this.backing.execute(feedback);
        int instruction = data / 100;
        int arg = data % 100;
        block0 : switch (instruction) {
            case 0: {
                feedback.log("HLT");
                break;
            }
            case 1: {
                feedback.log("ADD #" + TextValues.formatNumber(arg, 2) + " (" + this.backing.readMemory(arg) + ")");
                break;
            }
            case 2: {
                feedback.log("SUB #" + TextValues.formatNumber(arg, 2) + " (" + this.backing.readMemory(arg) + ")");
                break;
            }
            case 5: {
                feedback.log("LDA " + arg + " (loading " + this.backing.readMemory(arg) + " from #" + TextValues.formatNumber(arg, 2) + ")");
                break;
            }
            case 3: {
                feedback.log("STA " + arg + " (storing " + this.backing.readMemory(arg) + " into #" + TextValues.formatNumber(arg, 2) + ")");
                break;
            }
            case 6: {
                feedback.log("BRA " + arg + " (branch to #" + TextValues.formatNumber(arg, 2) + ")");
                break;
            }
            case 7: {
                feedback.log("BRZ " + arg + " (branch to #" + TextValues.formatNumber(arg, 2) + " if zero)");
                break;
            }
            case 8: {
                feedback.log("BRP " + arg + " (branch to #" + TextValues.formatNumber(arg, 2) + " if positive)");
                break;
            }
            case 9: {
                switch (arg) {
                    case 1: {
                        feedback.log("INP (" + this.backing.readInbox() + ")");
                        break block0;
                    }
                    case 2: {
                        feedback.log("OUT (" + this.backing.readOutbox() + ")");
                        break block0;
                    }
                }
                break;
            }
        }
        return data;
    }
}

