/*
 * Decompiled with CFR 0.152.
 */
package eden.emulator.lmc;

import craterstudio.text.Text;
import craterstudio.text.TextValues;
import java.util.HashMap;
import java.util.Map;

public class LmcParser {
    private final Map<String, Integer> labelToOffset = new HashMap<String, Integer>();
    private final LineResult[] results = new LineResult[100];
    private int resultOffset;
    private final int[] instrToLineNumber = new int[100];
    private static final Map<String, Integer> mnemonicToInstruction = new HashMap<String, Integer>();

    static {
        mnemonicToInstruction.put("HLT", 0);
        mnemonicToInstruction.put("ADD", 100);
        mnemonicToInstruction.put("SUB", 200);
        mnemonicToInstruction.put("LDA", 500);
        mnemonicToInstruction.put("STA", 300);
        mnemonicToInstruction.put("BRA", 600);
        mnemonicToInstruction.put("BRZ", 700);
        mnemonicToInstruction.put("BRP", 800);
        mnemonicToInstruction.put("INP", 901);
        mnemonicToInstruction.put("OUT", 902);
    }

    public int[][] compile() {
        this.resolveLabels();
        int[] instrs = this.convertToMachineCode();
        return new int[][]{instrs, (int[])this.instrToLineNumber.clone()};
    }

    public void feed(String line, int lineNumber) {
        int n;
        line = Text.beforeIfAny(line, "//");
        if ((line = line.trim()).isEmpty()) {
            return;
        }
        String[] parts = Text.splitOnWhiteSpace(line);
        int absolute = -1;
        LineResult result = new LineResult();
        String[] stringArray = parts;
        int n2 = parts.length;
        int n3 = 0;
        while (n3 < n2) {
            String part = stringArray[n3];
            if (part.startsWith("@")) {
                absolute = this.parseInstr(line, part.substring(1), 99);
            } else if (part.endsWith(":")) {
                result.label = part.substring(0, part.length() - 1);
            } else if (part.startsWith(":")) {
                result.reference = part.substring(1);
            } else {
                result.instruction = result.instruction + this.parseInstr(line, part, result.instruction > 0 ? 99 : 999);
            }
            ++n3;
        }
        if (result.label != null && this.labelToOffset.put(result.label, absolute == -1 ? this.resultOffset : absolute) != null) {
            throw new IllegalStateException("duplicate label: '" + result.label + "'");
        }
        if (absolute == -1) {
            int n4 = this.resultOffset;
            n = n4;
            this.resultOffset = n4 + 1;
        } else {
            n = absolute;
        }
        int index = n;
        this.results[index] = result;
        this.instrToLineNumber[index] = lineNumber;
    }

    private void resolveLabels() {
        LineResult[] lineResultArray = this.results;
        int n = this.results.length;
        int n2 = 0;
        while (n2 < n) {
            LineResult line = lineResultArray[n2];
            if (line != null && line.reference != null) {
                Integer offset = this.labelToOffset.get(line.reference);
                if (offset == null) {
                    throw new IllegalStateException("undefined label: '" + line.reference + "'");
                }
                line.reference = null;
                line.instruction += offset.intValue();
            }
            ++n2;
        }
    }

    private int[] convertToMachineCode() {
        int[] instructions = new int[100];
        int i = 0;
        while (i < instructions.length) {
            instructions[i] = this.results[i] == null ? 0 : this.results[i].instruction;
            ++i;
        }
        return instructions;
    }

    private int parseInstr(String line, String part, int max) {
        int instr = TextValues.tryParseInt(part, -1);
        if (instr == -1) {
            Integer got = mnemonicToInstruction.get(part);
            if (got == null) {
                throw new IllegalStateException("invalid line: " + line);
            }
            instr = got;
        }
        if (instr < 0 || instr > max) {
            throw new IllegalStateException("invalid line: " + line);
        }
        return instr;
    }

    class LineResult {
        String label;
        int instruction;
        String reference;

        LineResult() {
        }
    }
}

