/*
 * Decompiled with CFR 0.152.
 */
package eden.emulator.lmc;

import craterstudio.misc.gui.CssTextPane;
import craterstudio.misc.gui.SwingUtil;
import craterstudio.misc.gui.UserIO;
import craterstudio.text.Text;
import craterstudio.text.TextValues;
import craterstudio.util.HighLevel;
import eden.emulator.EmulatorCrash;
import eden.emulator.EmulatorFeedback;
import eden.emulator.lmc.Lmc;
import eden.emulator.lmc.LmcDebug;
import eden.emulator.lmc.LmcParser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class LmcUI {
    static CssTextPane sourcecode;
    static JTextArea logoutput;
    static JTextField[] memoryCells;
    static JTextField registerValue;
    static JCheckBox overflowFlag;
    static JButton loadButton;
    static JButton resetButton;
    static JButton dumpButton;
    static JButton stepButton;
    static JToggleButton loopButton;
    static JButton clearButton;
    static JButton instButton;
    static JButton labsButton;
    static JButton varsButton;
    static JButton modiButton;
    static Runnable funcStep;
    static Runnable funcLoad;
    private static int current_line;

    static {
        current_line = -1;
    }

    public static void main(String[] args) {
        final Lmc lmc = new Lmc();
        final int[] debug = new int[100];
        UserIO.setSystemLookAndFeel();
        final JPanel grid = new JPanel(new GridLayout(10, 10, 4, 4));
        memoryCells = new JTextField[100];
        int i = 0;
        while (i < 100) {
            LmcUI.memoryCells[i] = new JTextField();
            memoryCells[i].setPreferredSize(new Dimension(32, 18));
            memoryCells[i].setToolTipText("#" + TextValues.formatNumber(i, 2));
            grid.add(memoryCells[i]);
            ++i;
        }
        registerValue = new JTextField();
        registerValue.setPreferredSize(new Dimension(32, 18));
        overflowFlag = new JCheckBox("<< overflow");
        LmcUI.updateUI(lmc, debug);
        sourcecode = new CssTextPane();
        sourcecode.defineStyle("*        { color: #f00; font-style: italic;font-size:12; font-family: courier; } ");
        sourcecode.defineStyle("digit    { color: #00f; font-style: normal; } ");
        sourcecode.defineStyle("address  { color: #c0c; font-style: normal; } ");
        sourcecode.defineStyle("const    { color: #080; font-style: normal; } ");
        sourcecode.defineStyle("labeluse { color: #c40; font-style: normal; } ");
        sourcecode.defineStyle("labeldef { color: #808; font-style: normal; } ");
        sourcecode.defineStyle("comment  { color: #088; font-style: italic;text-decoration: none } ");
        sourcecode.defineStyle("currentline  { background-color: #def; }");
        sourcecode.defineStyle("previousline { background-color: #fff; }");
        String pre = "^|\\s|\\G";
        String post = "\\s|//|$";
        sourcecode.addSyntaxElement("digit", "(" + pre + ")(\\d+)(" + post + ")", 2);
        sourcecode.addSyntaxElement("address", "(" + pre + ")(@\\d+)(\\s|//|$)", 2);
        sourcecode.addSyntaxElement("const", "(" + pre + ")(HLT|ADD|SUB|STA|LDA|BRA|BRZ|BRP|INP|OUT)(" + post + ")", 2);
        sourcecode.addSyntaxElement("labeluse", "(" + pre + ")(:[a-zA-Z0-9]+)(" + post + ")", 2);
        sourcecode.addSyntaxElement("labeldef", "(" + pre + ")([a-zA-Z0-9]+:)(" + post + ")", 2);
        sourcecode.addSyntaxElement("comment", "(//.*$)", 1);
        sourcecode.activateUndoRedo();
        sourcecode.activateAutoRestyle();
        logoutput = new JTextArea();
        loadButton = new JButton("Compile and load instructions");
        dumpButton = new JButton("Dump memory...");
        resetButton = new JButton("Reset");
        stepButton = new JButton("Step");
        loopButton = new JToggleButton("Run...");
        clearButton = new JButton("Clear logs");
        instButton = new JButton("Print instructionset");
        labsButton = new JButton("How to: labels");
        varsButton = new JButton("How to: variables");
        modiButton = new JButton("How to: self-modify");
        logoutput.setEditable(false);
        logoutput.setBackground(Color.WHITE);
        logoutput.setForeground(Color.RED);
        final EmulatorFeedback feedback = new EmulatorFeedback(){

            @Override
            public int input() {
                String answer = null;
                int number = -1;
                while (true) {
                    try {
                        answer = UserIO.question(grid, "Input", "Enter a number:");
                        if (answer == null) {
                            throw new EmulatorCrash();
                        }
                        number = Integer.parseInt(answer);
                    }
                    catch (NumberFormatException numberFormatException) {
                        UserIO.say("Error", "Invalid number: " + answer);
                        continue;
                    }
                    break;
                }
                return number;
            }

            @Override
            public void output(int value) {
                UserIO.say(grid, "Output", "Value: " + value);
                LmcUI.log("OUTPUT: " + value);
            }

            @Override
            public void halt() {
                UserIO.warn(grid, "Halt!", "End of program");
                loopButton.setSelected(false);
            }

            @Override
            public void log(String description) {
                LmcUI.log("LMC: " + description);
            }

            @Override
            public void invalidAddress(int address) {
                LmcUI.log("LMC error: invalid address " + address);
            }

            @Override
            public void invalidInstruction() {
                LmcUI.log("LMC error: invalid instruction");
            }

            @Override
            public void crash() {
                LmcUI.log("LMC crash!!!");
            }
        };
        funcStep = new Runnable(){

            @Override
            public void run() {
                try {
                    new LmcDebug(lmc).execute(feedback);
                }
                catch (EmulatorCrash emulatorCrash) {
                    lmc.init();
                    feedback.crash();
                    loopButton.setSelected(false);
                }
                LmcUI.updateUI(lmc, debug);
            }
        };
        funcLoad = new Runnable(){

            @Override
            public void run() {
                loadButton.setEnabled(false);
                logoutput.setText("");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int[] db = LmcUI.compile(lmc, sourcecode.getText());
                        System.arraycopy(db, 0, debug, 0, debug.length);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                loadButton.setEnabled(true);
                            }
                        });
                    }
                }).start();
            }
        };
        loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                funcLoad.run();
            }
        });
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                funcLoad.run();
            }
        });
        dumpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean skipped = false;
                        LmcUI.log("---");
                        int i = 0;
                        while (i < 100) {
                            int val = lmc.readMemory(i);
                            if (val != 0) {
                                LmcUI.log(String.valueOf(skipped ? "@" + i + " " : "") + String.valueOf(val));
                                skipped = false;
                            } else {
                                skipped = true;
                            }
                            ++i;
                        }
                        LmcUI.log("---");
                    }
                }).start();
            }
        });
        stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                funcStep.run();
            }
        });
        loopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (loopButton.isSelected()) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            while (loopButton.isSelected()) {
                                funcStep.run();
                            }
                        }
                    }).start();
                }
            }
        });
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logoutput.setText("");
            }
        });
        instButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logoutput.setText("");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LmcUI.log("1xx [ADD xx] adds value at 'xx' to register");
                        LmcUI.log("2xx [SUB xx] subs value at 'xx' from register");
                        LmcUI.log("3xx [LDA xx] loads value at 'xx' into register");
                        LmcUI.log("5xx [STA xx] stores register into address 'xx'");
                        LmcUI.log("6xx [BRA xx] branches to 'xx'");
                        LmcUI.log("7xx [BRZ xx] branches to 'xx' on zero reg.");
                        LmcUI.log("8xx [BRP xx] branches to 'xx' on positive reg.");
                        LmcUI.log("             (overflow-flag was not set)");
                        LmcUI.log("901 [INP]    loads in-box value into register");
                        LmcUI.log("902 [OUT]    puts register value into out-box");
                    }
                }).start();
            }
        });
        labsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logoutput.setText("");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LmcUI.log("Example: add two numbers in a loop");
                        LmcUI.log("");
                        LmcUI.log("  loop12: INP          // defined a label");
                        LmcUI.log("          STA 99       // store in mem[99]");
                        LmcUI.log("          INP          // request value");
                        LmcUI.log("          ADD 99       // add value at mem[99]");
                        LmcUI.log("          OUT          // output value");
                        LmcUI.log("          BRA :loop12  // referred to a label");
                    }
                }).start();
            }
        });
        varsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logoutput.setText("");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LmcUI.log("The following example prints: 5,4,3,2,1");
                        LmcUI.log("");
                        LmcUI.log("// load value, stop if zero");
                        LmcUI.log("LDA :var // load from mem[:var]");
                        LmcUI.log("BRZ :end // branch to :end if zero");
                        LmcUI.log("OUT");
                        LmcUI.log("");
                        LmcUI.log("// decrement mem[:var]");
                        LmcUI.log("LDA :var // load from mem[:var]");
                        LmcUI.log("SUB :one // sub mem[:var] which is 1");
                        LmcUI.log("STA :var // store into mem[:var]");
                        LmcUI.log("");
                        LmcUI.log("BRA 0    // branch to 0");
                        LmcUI.log("end: HLT // this is a label");
                        LmcUI.log("var: 5   // this is a variable");
                        LmcUI.log("zero: 0  // this is another variable");
                        LmcUI.log("one: 1   // this is yet another variable");
                        LmcUI.log("@99 t: 2 // this is a variable at mem[99]");
                        LmcUI.log("");
                        LmcUI.log("// PLEASE NOTE:");
                        LmcUI.log("// 'BRA 0' means branch to 0");
                        LmcUI.log("// 'BRA :zero' means branch to label 'zero'");
                        LmcUI.log("//             which can be anywhere!");
                    }
                }).start();
            }
        });
        modiButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logoutput.setText("");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LmcUI.log("The following example modifies itself:");
                        LmcUI.log("");
                        LmcUI.log("// will be modified");
                        LmcUI.log("LDA 90");
                        LmcUI.log("BRZ :end // @99");
                        LmcUI.log("OUT");
                        LmcUI.log("");
                        LmcUI.log("// modify instr.:");
                        LmcUI.log("// load next address");
                        LmcUI.log("LDA 0");
                        LmcUI.log("ADD :one");
                        LmcUI.log("STA 0");
                        LmcUI.log("");
                        LmcUI.log("BRA 0 // loop");
                        LmcUI.log("end: HLT");
                        LmcUI.log("");
                        LmcUI.log("one: 1");
                        LmcUI.log("");
                        LmcUI.log("// load powers of 2");
                        LmcUI.log("@90 2");
                        LmcUI.log("@91 4");
                        LmcUI.log("@92 8");
                        LmcUI.log("@93 16");
                        LmcUI.log("@94 32");
                        LmcUI.log("@95 64");
                        LmcUI.log("@96 128");
                        LmcUI.log("@97 256");
                        LmcUI.log("@98 512");
                        LmcUI.log("@99 0");
                        LmcUI.log("");
                    }
                }).start();
            }
        });
        JPanel codePanel = new JPanel(new BorderLayout(8, 8));
        codePanel.add((Component)new JLabel("Instructions:"), "North");
        codePanel.add((Component)sourcecode.wrapInScrollPane(), "Center");
        codePanel.add((Component)loadButton, "South");
        JPanel gridPanel = new JPanel(new BorderLayout(8, 8));
        gridPanel.add((Component)new JLabel("Memory:"), "North");
        gridPanel.add((Component)grid, "North");
        JPanel buttons = new JPanel(new FlowLayout(2, 8, 0));
        buttons.add(resetButton);
        buttons.add(stepButton);
        buttons.add(loopButton);
        buttons.add(new JLabel("Register:"));
        buttons.add(registerValue);
        buttons.add(overflowFlag);
        gridPanel.add((Component)buttons, "South");
        JPanel logPanel = new JPanel(new BorderLayout(8, 8));
        logPanel.add((Component)new JLabel("Emulator logs:"), "North");
        logPanel.add((Component)new JScrollPane(logoutput){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(384, 1);
            }
        }, "Center");
        JPanel buttons1 = new JPanel(new FlowLayout(1, 8, 0));
        buttons1.add(instButton);
        buttons1.add(dumpButton);
        buttons1.add(clearButton);
        JPanel buttons2 = new JPanel(new FlowLayout(1, 8, 0));
        buttons2.add(labsButton);
        buttons2.add(varsButton);
        buttons2.add(modiButton);
        JPanel buttons12 = new JPanel(new BorderLayout(0, 2));
        buttons12.add((Component)buttons1, "North");
        buttons12.add((Component)buttons2, "South");
        logPanel.add((Component)buttons12, "South");
        JPanel gridAndLogPanel = new JPanel(new BorderLayout(8, 8));
        gridAndLogPanel.add((Component)gridPanel, "Center");
        gridAndLogPanel.add((Component)logPanel, "East");
        gridAndLogPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JPanel cp1 = new JPanel(new BorderLayout(8, 8));
        cp1.add((Component)codePanel, "Center");
        cp1.add((Component)gridAndLogPanel, "East");
        cp1.setBorder(new EmptyBorder(8, 8, 8, 8));
        UserIO.createDefaultFrame(cp1, "LMC Emulator", true);
        instButton.doClick();
    }

    public static int[] compile(Lmc lmc, String sourcecode) {
        int[][] machinecodeAndDebug;
        LmcUI.log("Compiling source...");
        LmcParser parser = new LmcParser();
        int lineCounter = 0;
        String[] stringArray = Text.splitOnLines(sourcecode);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCounter;
            try {
                parser.feed(line, lineCounter);
            }
            catch (Exception exception) {
                LmcUI.log("Error on line #" + lineCounter + ": '" + line + "'");
                return new int[100];
            }
            ++n2;
        }
        try {
            machinecodeAndDebug = parser.compile();
        }
        catch (Exception exc) {
            LmcUI.log("Failed to resolve labels: " + exc.getMessage());
            return new int[100];
        }
        int[] machinecode = machinecodeAndDebug[0];
        int[] debug = machinecodeAndDebug[1];
        LmcUI.log("Compilation successful.");
        try {
            lmc.load(machinecode);
        }
        catch (Exception exc) {
            logoutput.append("\r\nError: " + exc.getMessage());
            return new int[100];
        }
        LmcUI.log("Loaded machinecode into memory.");
        LmcUI.updateUI(lmc, debug);
        return debug;
    }

    public static void log(final String line) {
        HighLevel.sleep(100L);
        SwingUtil.sync(new Runnable(){

            @Override
            public void run() {
                if (!logoutput.getText().isEmpty()) {
                    logoutput.append("\r\n");
                }
                logoutput.append(line);
            }
        });
    }

    public static void updateUI(Lmc lmc, int[] debug) {
        if (current_line != -1) {
            sourcecode.applyStyleOnLine("previousline", current_line);
        }
        if (lmc.getLastInstructionPointer() != -1 && (current_line = debug[lmc.getInstructionPointer()]) != 0) {
            sourcecode.applyStyleOnLine("currentline", current_line);
        }
        int i = 0;
        while (i < 100) {
            Color color = lmc.getLastInstructionPointer() == i ? Color.RED : (lmc.getLastReference() == i ? Color.GREEN : Color.BLUE);
            memoryCells[i].setText(String.valueOf(lmc.readMemory(i)));
            memoryCells[i].setHorizontalAlignment(4);
            memoryCells[i].setEditable(false);
            memoryCells[i].setBackground(Color.WHITE);
            memoryCells[i].setForeground(Color.GRAY);
            memoryCells[i].setBorder(new LineBorder(color));
            ++i;
        }
        registerValue.setText(String.valueOf(lmc.readRegister()));
        registerValue.setHorizontalAlignment(4);
        registerValue.setEditable(false);
        registerValue.setBackground(Color.WHITE);
        registerValue.setForeground(Color.GRAY);
        registerValue.setBorder(new LineBorder(Color.GRAY));
        overflowFlag.setSelected(lmc.getOverflowFlag());
        overflowFlag.setEnabled(false);
    }
}

