package it.unich.easytelegram;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public class Chat {

    private BlockingQueue<String> inputs = new LinkedBlockingQueue<>();
    private long chatId;
    private BotController botController;
    private Thread thread;

    Chat(long chatId, BotController botController) {
        this.chatId = chatId;
        this.botController = botController;
        log("Starting for bot " + botController);
        thread = new Thread(() -> {
            while (true)
                try {
                    log("Running main");
                    botController.getBot().invokeExact(this);
                } catch (Throwable e) {
                    Chat.this.print(e.toString());
                    log(e.toString());
                }
        });
        thread.start();
    }

    public long getId() {
        return chatId;
    }

    public void log(String msg) {
        botController.log(this, msg);
    }

    public void processInput(String s) {
        log("processed input " + s);
        inputs.add(s);
    }

    private String getMessage() {
        var s = "";
        try {
            s = inputs.take();
        } catch (InterruptedException e) {
        }
        return s;
    }

    public int nextInt() {
        log("nextInt called");
        var s = getMessage();
        log(s + " retrieved");
        return Integer.parseInt(s);
    }

    public double nextDouble() {
        log("nextInt called");
        var s = getMessage();
        log(s + " retrieved");
        return Double.parseDouble(s);
    }

    public String nextLine() {
        log("nextInt called");
        var s = getMessage();
        log(s + " retrieved");
        return s;
    }

    public void print(String s) {
        log("print");
        SendMessage message = new SendMessage(Long.valueOf(chatId).toString(), s);
        try {
            botController.execute(message); // Call method to send the message
        } catch (TelegramApiException e) {
            e.printStackTrace();
        }
        inputs.clear();
    }

    public void print(char c) {
        print(Character.toString(c));
    }

    public void print(int i) {
        print(Integer.toString(i));
    }

    public void print(long l) {
        print(Long.toString(l));
    }

    public void print(double d) {
        print(Double.toString(d));
    }

    public void print(float f) {
        print(Float.toString(f));
    }

    public void print() {
        print("");
    }

}
